/*
 * Decompiled with CFR 0.152.
 */
package com.smart.io;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.util.Log;
import com.smart.io.PortManager;
import com.smart.io.WriterResult;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BluetoothPort
extends PortManager {
    private static final String TAG = BluetoothPort.class.getSimpleName();
    private static final UUID SERIAL_PORT_SERVICE_CLASS_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private static final String NAME = "BluetoothPort";
    private BluetoothAdapter mAdapter = null;
    private BluetoothDevice device;
    private BluetoothSocket mSocket;
    private int state = 0;
    private int len = 0;
    private String macAddress;
    private BufferedOutputStream bufferedOutputStream;
    private ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();

    private void initSocketStream() throws IOException {
        this.inputStream = this.mSocket.getInputStream();
        this.outputStream = this.mSocket.getOutputStream();
        this.bufferedOutputStream = new BufferedOutputStream(this.outputStream);
    }

    @Override
    public boolean openPort() {
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mAdapter.cancelDiscovery();
        if (this.mAdapter == null) {
            this.state = 0;
            Log.e((String)TAG, (String)"Bluetooth is not support");
        } else if (!this.mAdapter.isEnabled()) {
            this.state = 0;
            Log.e((String)TAG, (String)"Bluetooth is not open");
        } else {
            try {
                if (BluetoothAdapter.checkBluetoothAddress((String)this.macAddress)) {
                    this.device = this.mAdapter.getRemoteDevice(this.macAddress);
                    this.mSocket = this.device.createInsecureRfcommSocketToServiceRecord(SERIAL_PORT_SERVICE_CLASS_UUID);
                    this.mSocket.connect();
                    this.initSocketStream();
                    this.state = 3;
                    return true;
                }
                this.state = 0;
                Log.e((String)TAG, (String)"Bluetooth address is invalid");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.macAddress = "";
        return false;
    }

    @Override
    public boolean isConnect() {
        try {
            if (this.mSocket != null && this.mSocket.isConnected() && this.mSocket.getInputStream() != null && this.mSocket.getOutputStream() != null) {
                this.outputStream.write(new byte[0]);
                return true;
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        return false;
    }

    public BluetoothPort(String macAddress) {
        this.macAddress = macAddress;
    }

    @Override
    public void writeDataImmediately(Vector<Byte> data) throws IOException {
        this.writeDataImmediately(data, 0, data.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDataImmediately(Vector<Byte> data, int offset, int len) throws IOException {
        if (this.mSocket != null && this.outputStream != null && data != null && data.size() > 0) {
            try {
                this.reentrantReadWriteLock.writeLock().lock();
                this.outputStream.write(this.convertVectorByteToBytes(data), offset, len);
                this.outputStream.flush();
                this.reentrantReadWriteLock.writeLock().unlock();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Exception occured while sending data immediately: ", (Throwable)e);
            }
            finally {
                this.bufferedOutputStream.flush();
            }
        }
    }

    @Override
    public synchronized void writeDataImadiately(Vector<Byte> data, int offset, int len, long timeout, WriterResult result, int ... receiveLen) {
        block10: {
            if (data == null || data.size() <= 0) {
                result.error(-3);
            }
            try {
                if (this.mSocket != null && this.outputStream != null) {
                    if (data != null && data.size() > 0) {
                        this.reentrantReadWriteLock.writeLock().lock();
                        this.outputStream.write(this.convertVectorByteToBytes(data), offset, len);
                        this.outputStream.flush();
                        result.sendFinish();
                        this.reentrantReadWriteLock.writeLock().unlock();
                    }
                    byte[] buffer = new byte[10];
                    int i = 0;
                    while ((long)i < timeout / 5L) {
                        int l = this.inputStream.available();
                        if (l > 0) {
                            Log.i((String)TAG, (String)("available - " + l));
                            l = this.inputStream.read(buffer, 0, buffer.length);
                            if (l != 3 && l != 6) {
                                result.other(l, buffer);
                                break block10;
                            }
                            BluetoothPort.parsing(buffer, l, result);
                        }
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                    break block10;
                }
                result.error(-2);
            }
            catch (IOException e) {
                result.error(-1);
            }
        }
    }

    @Override
    public void writeDataImadiately(byte[] data) throws IOException {
        this.reentrantReadWriteLock.writeLock().lock();
        this.outputStream.write(data);
        this.outputStream.flush();
        this.reentrantReadWriteLock.writeLock().unlock();
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    private static void parsing(byte[] buffer, int len, WriterResult writerResult) {
        if (BluetoothPort.compare(buffer, len, new byte[]{31, 5, 27}, 3)) {
            writerResult.error(-10);
        } else if (BluetoothPort.compare(buffer, len, new byte[]{31, 1, 27}, 3)) {
            writerResult.error(-5);
        } else if (BluetoothPort.compare(buffer, len, new byte[]{31, 2, 27}, 3)) {
            writerResult.error(-6);
        } else if (BluetoothPort.compare(buffer, len, new byte[]{31, 4, 27}, 3)) {
            writerResult.error(-7);
        } else if (BluetoothPort.compare(buffer, len, new byte[]{31, 8, 27}, 3)) {
            writerResult.error(-8);
        } else if (BluetoothPort.compare(buffer, len, new byte[]{31, 0, 27}, 3)) {
            writerResult.normal();
        } else if (BluetoothPort.compare(buffer, len, new byte[]{31, 16, 27}, 3)) {
            writerResult.error(-11);
        } else if (buffer[0] == 95 && buffer[2] == 95) {
            writerResult.error(-9);
        }
        writerResult.error(-12);
    }

    private static boolean compare(byte[] byte1, int byte1Len, byte[] byte2, int byte2Len) {
        if (byte1Len >= byte2Len) {
            int a = 0;
            for (int i = 0; i < byte1Len; ++i) {
                if (byte1[i] == byte2[a]) {
                    if (++a != byte2Len - 1) continue;
                    return true;
                }
                a = 0;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean readData(byte[] bytes, int len, long timeout) throws IOException {
        if (this.inputStream == null) {
            return false;
        }
        int i = 0;
        while ((long)i < timeout / 5L) {
            if (this.inputStream.available() == len) {
                this.inputStream.read(bytes, 0, len);
                return true;
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
            ++i;
        }
        return false;
    }

    public void readData(byte[] bytes, int len) {
    }

    @Override
    public boolean closePort() {
        try {
            this.closeConn();
            this.state = 0;
            return true;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Close port error! ", (Throwable)e);
            return false;
        }
    }

    private void closeConn() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
        if (this.bufferedOutputStream != null) {
            this.bufferedOutputStream.close();
            this.bufferedOutputStream = null;
        }
        if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
        if (this.mSocket != null) {
            this.mSocket.close();
            this.mSocket = null;
        }
    }
}

